#include <allegro.h>

#include "actor.h"
#include "draw.h"
#include "alienship.h"
#include "sectors.h"
#include "man.h"
#include "game.h"
#include "F18.h"

float F180_points[] = {
	    -2.884,     18.745, // 0
	    -2.286,     25.972, // 1
	    -4.872,     36.722, // 2
	     7.210,     37.850, // 3
	    10.313,     26.299, // 4
	     2.787,     32.785, // 5
	     6.254,     33.293, // 6
	     8.803,     33.160, // 7
	    13.338,     32.803, // 8
	     9.806,     29.766, // 9
	     7.570,     27.757, // 10
	     3.244,     27.757, // 11
	   -31.722,     29.559, // 12
	   -11.896,     14.419, // 13
	   -34.966,      1.081, // 14
	    30.641,     14.419, // 15
	    -1.442,      6.849, // 16
	    -2.163,      4.326, // 17
	    20.187,      5.047, // 18
	    21.629,      8.291  // 19
};
int F180_lines[] = {
	1, 0, 0, 0, 0,
	4, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	6, 5, 0, 0, 0,
	7, 3, 0, 0, 0,
	7, 8, 0, 0, 0,
	8, 9, 0, 0, 0,
	9, 4, 0, 0, 0,
	11, 10, 0, 0, 0,
	14, 15, 0, 0, 0,
	15, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 14, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 16, 0, 0, 0,
	16, 19, 0, 0, 0 
};
float F181_points[] = {
	    -2.884,     18.745, // 0
	    -2.286,     25.972, // 1
	    -5.047,     36.408, // 2
	     7.210,     37.850, // 3
	    10.313,     26.299, // 4
	     1.802,     33.164, // 5
	     6.254,     33.293, // 6
	     8.803,     33.160, // 7
	    12.977,     32.083, // 8
	     9.806,     29.766, // 9
	     7.570,     27.757, // 10
	     3.244,     27.757, // 11
	   -30.641,     32.803, // 12
	   -11.896,     14.419, // 13
	   -34.606,      0.000, // 14
	    31.001,     14.780, // 15
	    -1.442,      6.849, // 16
	    -1.081,      4.326, // 17
	    19.466,      2.523, // 18
	    19.105,      6.489  // 19
};
int F181_lines[] = {
	1, 0, 0, 0, 0,
	4, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	6, 5, 0, 0, 0,
	7, 3, 0, 0, 0,
	7, 8, 0, 0, 0,
	8, 9, 0, 0, 0,
	9, 4, 0, 0, 0,
	11, 10, 0, 0, 0,
	14, 15, 0, 0, 0,
	15, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 14, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 16, 0, 0, 0,
	16, 19, 0, 0, 0 
};

float F18dead_points[] = {
	    15.597,     10.398, // 0
	    20.686,     14.029, // 1
	    28.422,     22.183, // 2
	    35.974,     14.173, // 3
	    28.235,      4.816, // 4
	    28.948,     15.753, // 5
	    31.623,     11.295, // 6
	    32.753,      8.739, // 7
	    33.942,      5.410, // 8
	    29.781,      6.956, // 9
	    27.819,      8.204, // 10
	    25.798,     12.246, // 11
	   -15.944,     27.035, // 12
	   -10.398,      5.892, // 13
	   -34.606,      0.000, // 14
	    35.007,     -0.347, // 15
	     0.347,      3.813, // 16
	     0.000,      1.040, // 17
	    20.450,      1.040, // 18
	    20.103,      4.506  // 19
};
int F18dead_lines[] = {
	1, 0, 0, 0, 0,
	4, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	6, 5, 0, 0, 0,
	7, 3, 0, 0, 0,
	7, 8, 0, 0, 0,
	8, 9, 0, 0, 0,
	9, 4, 0, 0, 0,
	11, 10, 0, 0, 0,
	14, 15, 0, 0, 0,
	15, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 14, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 16, 0, 0, 0,
	16, 19, 0, 0, 0 
};

void F18_process(int num)
{
	int remove = 0;
	ACTOR *actor = man[num];
	
	if (actor->hit) {
		if (actor->frame < 2) {
			actor->timer = 0;
			actor->frame = 2;
			actor->anim = 0;
		}
		actor->anim++;
		if (actor->anim == 16) {
			actor->anim = 0;
			actor->frame++;
			if (actor->frame == 4) {
				actor->timer++;
				actor->frame = 3;
			}
		}
		if (actor->y > 0) {
			actor->dy--;
			actor->y += actor->dy;
		} else {
			actor->y = 0;
		}
	} else {
	
		if (actor->dx == 0) {
			actor->dx = 1;
		}
		actor->x += actor->dx;
		
		actor->timer++;
		
		if (actor_collide(actor, &alienship)) {
			alienship.health -= 150;
			actor->hit = 1;
			population--;
			actor->dx = -actor->dx;
			alienship.dx = -alienship.dx;
		}
		
		if (actor->timer == 3000) {
			actor->timer = 0;
			actor->dx = -actor->dx;
		}
		
		if (actor->x > SECTORS * SECTOR_DIMENSION)
			actor->x -= SECTORS * SECTOR_DIMENSION;
		
		if (actor->x < 0)
			actor->x += SECTORS * SECTOR_DIMENSION;

		actor->anim++;
		if (actor->anim == 16) {
			actor->anim = 0;
			actor->frame++;
			if (actor->frame == 2) actor->frame = 0;
		}
	}
	
	{
		float d = actor->x - alienship.x;
		if (d > SECTORS * SECTOR_DIMENSION / 2) {
			d -= SECTORS * SECTOR_DIMENSION;
		}
		if (d < -SECTORS * SECTOR_DIMENSION / 2) {
			d += SECTORS * SECTOR_DIMENSION;
		}
		if ( d > 3000 || d < -3000 || alienship.y > 3000) {
			if (actor->hit && actor->timer >= 100) {
				remove = 1;
			} else {
				if (sector_place_man(actor)) remove = 1;
			}
		}
	}
	
	if (remove) {
		mans_num--;
		if (mans_num > 0) {
			man[num] = man[mans_num];
			man_process(num);
		}
	}
}

static void F18_draw(ACTOR *actor, int x, int y)
{
	if (actor->dx > 0) {
		if (actor->frame == 0) draw_(x, y, points(F180), lines(F180), F180_points, F181_points, F180_lines, actor->anim / 16.0);
		if (actor->frame == 1) draw_(x, y, points(F181), lines(F181), F181_points, F180_points, F181_lines, actor->anim / 16.0);
		if (actor->frame == 2) draw_(x, y, points(F180), lines(F180), F180_points, F18dead_points, F180_lines, actor->anim / 16.0);
		if (actor->frame == 3) draw_(x, y, points(F18dead), lines(F18dead), F18dead_points, F18dead_points, F18dead_lines, actor->anim / 16.0);
	}
	if (actor->dx < 0) {
		if (actor->frame == 0) m_draw_(x, y, points(F180), lines(F180), F180_points, F181_points, F180_lines, actor->anim / 16.0);
		if (actor->frame == 1) m_draw_(x, y, points(F181), lines(F181), F181_points, F180_points, F181_lines, actor->anim / 16.0);
		if (actor->frame == 2) m_draw_(x, y, points(F180), lines(F180), F180_points, F18dead_points, F180_lines, actor->anim / 16.0);
		if (actor->frame == 3) m_draw_(x, y, points(F18dead), lines(F18dead), F18dead_points, F18dead_points, F18dead_lines, actor->anim / 16.0);
	}
}

ACTOR *F18_init(void)
{
	ACTOR *actor;
	if (mans_total == TOTAL_MANS) return NULL;
	actor = &(all_mans[mans_total]);
	actor_init(actor);
	bound_(points(F180), F180_points, &actor->l, &actor->t, &actor->r, &actor->b);
	actor->draw = F18_draw;
	actor->type = 2;

	if ((rand() >> 8) & 1) actor->dx = 1; else {
		float t = actor->l;
		actor->dx = -1;
		actor->l = -actor->r;
		actor->r = -t;
	}
	
	mans_total++;
	return actor;
}
